create or replace package tbicds.PCK_COMMON
AUTHID CURRENT_USER 
is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  -- Public type declarations
  type refCursor is ref cursor;
  --todo: update righs using entries in STAT_USER_RIGHTS
  c_nNoneUR                          constant binary_integer := 0;   -- 0000000000000000
  c_nDataManagementUR                constant binary_integer := 1;   -- 0000000000000001
  c_nCaseManagementUR                constant binary_integer := 2;   -- 0000000000000010
  c_nPopulationReportingUR           constant binary_integer := 4;   -- 0000000000000100
  c_nTxAssessmentPlanningUR          constant binary_integer := 8;   -- 0000000000001000
  c_nSignNoteUR                      constant binary_integer := 16;  -- 0000000000010000
  c_nCloseNoteUR                     constant binary_integer := 32;  -- 0000000000100000
  c_nProcessNewPatientsUR            constant binary_integer := 64;  -- 0000000001000000
  c_nAdministratorUR                 constant binary_integer := 131072; -- 0000000010000000
  
  c_nMAJCOMUR    constant binary_integer := 32768; --1000000000000000;
  c_nHQUR        constant binary_integer := 32768; --1000000000000000;

  c_nResultStatus_Error   constant binary_integer := 1;
  c_nResultStatus_Success constant binary_integer := 0;

  
  --status codes
  c_nStatus_Success constant number(1) := 1;
  c_nStatus_Error   constant number(1) := 2;
  c_nStatus_Unknown constant number(1) := 3;

  --status texts
  c_vStatus_Default   constant varchar2(255) := '';
  c_vStatus_undefined constant varchar2(255) := 'An undefined error occurred, please contact your system administrator!';

  --are we in debug mode? 1 = yes, 0 = no
  c_nDebug_Mode constant number(1) := 1;

  --used for Enquote Literal
  c_nDoubleTic constant varchar2(2) := '''';

  -- STAT_ACTIVE
  c_nActive   constant number(1) := 1;
  c_nInactive constant number(1) := 2;

  --Active Filter
  c_nFilterActive   constant number(1) := 1;
  c_nFilterInactive constant number(1) := 2;
  c_nShowActiveAll  constant number(1) := 3;

  /*****
  Description:
  helper function used to get age given date of birth
  *****/
  function GetAge(pi_dtDOB in date) return number;

  /*****
  Description:
  helper function used to get a piece of data
  *****/
  function GetPiece(strData      in varchar2,
                    strDelimiter in varchar2,
                    nPosition    in NUMBER) return varchar2;

   /*****
  Description:
  helper function used to get a comma separated value list from a cursor
  *****/
  function join(p_cursor sys_refcursor, p_del varchar2 := ',')
    return varchar2;

end;
/

